function [that, fval]=estimate_GMM(yB,yA,y1,y2,y3,y4,xB,xA,x1,x2,x3,x4,thstart,W0,print,should_scale,options)

    if nargin<17
        options=0;
    end
    
   
    x=thstart;

    A = [];
    b = [];
    Aeq = [];
    beq = [];
    lb=0*x-6;
    ub=0*x+6;
    fun=@(th)fct1(yB,yA,y1,y2,y3,y4,xB,xA,x1,x2,x3,x4,th,W0,0,should_scale);
    opti=optimoptions(@fmincon,'MaxFunctionEvaluations',10000,'MaxIterations',10000,'Display','off');
    [x,fval] = fmincon(fun, x,A,b,Aeq,beq,lb,ub,[],opti);
    if print
        fprintf('  Fminunc =%9.6f ',fval)
    end
    if options==1
        [x,fval] = powell(fun,x,100,1.0d-6);
     
        if print
            diary on
            fprintf('\n  Powell  =%9.6f \n',fval)
            diary off
        end
        

        
        de=1;
        options=optimoptions('particleswarm','SwarmSize',5000,'MaxIterations',50,'Display','iter','InitialSwarm',x','UseParallel',true,'FunctionTolerance',1.0d-4);
        [bhat, fval]=particleswarm(fun,length(x),(x-de)',(x+de)',options);
        x=bhat';
        diary on
        fprintf('PS Optimized Value %9.6f\n\n', fval)
        diary off
        
        [x,fval] = fmincon(fun, x,A,b,Aeq,beq,lb,ub,[],opti);
        if print
            diary on
            fprintf('\n  Fminunc =%9.6f \n',fval)
            diary off
        end
    end
 
    that=x;
end